package com.androidsmile.labbluetooth;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.SeekBar;
import java.math.BigInteger;
import app.akexorcist.bluetotohspp.library.BluetoothSPP;
import app.akexorcist.bluetotohspp.library.BluetoothState;
import app.akexorcist.bluetotohspp.library.DeviceList;


public class MainActivity extends AppCompatActivity {

   int temp;
   int temp2;
   int kol;
   int asd;


   String[] arr;


    BluetoothSPP bluetooth;
    TextView txtArduino;
    TextView textView7;
    TextView textView9;
    TextView textView;
    TextView textView3;
    TextView textView10;
    SeekBar seekBar;
    Button connect;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        bluetooth = new BluetoothSPP(this);
        connect = (Button) findViewById(R.id.connect);
        txtArduino = (TextView) findViewById(R.id.txtArduino);
        textView7 = (TextView) findViewById(R.id.textView7);
        textView3 = (TextView) findViewById(R.id.textView3);
        textView9 = (TextView) findViewById(R.id.textView9);
        textView = (TextView) findViewById(R.id.textView);
        textView10 = (TextView) findViewById(R.id.textView10);
        seekBar = (SeekBar) findViewById(R.id.seekBar);

        if (!bluetooth.isBluetoothAvailable()) {
            Toast.makeText(getApplicationContext(), "Bluetooth не доступен", Toast.LENGTH_SHORT).show();
            finish();
        }

        bluetooth.setBluetoothConnectionListener(new BluetoothSPP.BluetoothConnectionListener() {
            public void onDeviceConnected(String name, String address) {
                connect.setText("Подключен " + name);
            }

            public void onDeviceDisconnected() {
                connect.setText("Связь потеряна");
            }

            public void onDeviceConnectionFailed() {
                connect.setText("Не удается подключиться");
            }
        });

        connect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (bluetooth.getServiceState() == BluetoothState.STATE_CONNECTED) {
                    bluetooth.disconnect();
                } else {
                    Intent intent = new Intent(getApplicationContext(), DeviceList.class);
                    startActivityForResult(intent, BluetoothState.REQUEST_CONNECT_DEVICE);
                }
            }
        });

////////////////////////// прием данных с порта ................!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        bluetooth.setOnDataReceivedListener(new BluetoothSPP.OnDataReceivedListener() {
            public void onDataReceived(byte[] data, String message) {
              //  Toast.makeText(getApplicationContext(), String.format("Data Received: %s", message),
                 //       Toast.LENGTH_SHORT).show();
                kol = message.length();// длина string
                if(kol>4) {
                    arr = message.split(":");// разбивка string
                    temp2 = Integer.parseInt(arr[1].trim());// string to int
                    temp = Integer.parseInt(arr[2].trim());// string to int
                    txtArduino.setText(arr[0] + "\u00B0C");
                    textView.setText(temp2 + "\u00B0C");

                    if(temp == 1){
                    textView3.setText("ON");}
                    else{
                        textView3.setText("OFF");}
                }

/////////////////////////////////// SeekBar /////////////////////////////////////////////////


                String text = seekBar.getProgress() + " из " + seekBar.getMax();
                textView10.setText(text);

                if(asd==0){
                    seekBar.post(new Runnable() {
                        @Override
                        public void run() {
                            seekBar.setProgress(temp2);
                        }
                    });
                }

                // устанавливаем слушатель для реакции на различные события в SeekBar
                seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                    int progress = 0 ;


                    @Override
                    public void onProgressChanged(SeekBar seekBar, int progressValue, boolean fromUser) {
                        progress = progressValue;
                        asd=1;
                    }


                    @Override
                    public void onStartTrackingTouch(SeekBar seekBar) {

                    }

                    @Override
                    public void onStopTrackingTouch(SeekBar seekBar) {
                        // значение прогресса отображаем в TextView
                        String resultText = progress + " из " + seekBar.getMax();
                        String asdText = "11" + seekBar.getProgress();
                        textView10.setText(resultText);
                        bluetooth.send(asdText, true);
                    }


                });
////////////////////////////////////////////////////////////////////////////////////////////////////////


            } });




    }/// onCreate

    public void onStart() {
        super.onStart();
        if (!bluetooth.isBluetoothEnabled()) {
            bluetooth.enable();
        } else {
            if (!bluetooth.isServiceAvailable()) {
                bluetooth.setupService();
                bluetooth.startService(BluetoothState.DEVICE_OTHER);
            }
        }
    }


    public void onDestroy() {
        super.onDestroy();
        bluetooth.stopService();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == BluetoothState.REQUEST_CONNECT_DEVICE) {
            if (resultCode == Activity.RESULT_OK)
                bluetooth.connect(data);
        } else if (requestCode == BluetoothState.REQUEST_ENABLE_BT) {
            if (resultCode == Activity.RESULT_OK) {
                bluetooth.setupService();
            } else {
                Toast.makeText(getApplicationContext()
                        , "Bluetooth не был включен"
                        , Toast.LENGTH_SHORT).show();
                finish();
            }
        }
    }

}

